/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters.imagehandlers;

import com.webcodepro.applecommander.storage.filters.imagehandlers.AppleImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class SunJpegImage
extends AppleImage {
    private BufferedImage image;

    public SunJpegImage(int width, int height) throws ClassNotFoundException {
        super(new String[]{"JPEG"});
        Class.forName("com.sun.image.codec.jpeg.JPEGCodec");
        this.image = new BufferedImage(width, height, 1);
    }

    @Override
    public void setPoint(int x, int y, int color) {
        this.image.setRGB(x, y, color);
    }

    @Override
    public int getPoint(int x, int y) {
        return this.image.getRGB(x, y);
    }

    @Override
    public void save(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.image, "jpg", outputStream);
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }
}

